package client_server;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

public class ServicesImpl extends UnicastRemoteObject implements ServicesInterface
{
        public ServicesImpl(String name) throws RemoteException
                {
                super();
                try
                        {
                        Naming.rebind(name, this);
                        }
                catch(Exception e)
                        {
                        }
                }
        
        
        public Vector<String[]> getRemotePlayersInfo()
                {
        	     return Server.instance.playerList;
                }
        
        

        public void setPlayerInfo(String[] info) throws RemoteException {
        	for (String[] nf:Server.instance.playerList){
        		if (nf[0].equals(info[0]))
        			{
        			 nf[1] = info[1];//stato
        			 nf[2] = info[2];//orientation
        			 nf[3] = info[3];//x
        			 nf[4] = info[4];//y
        			}
        	}
		}

/**<p>
 * 0 = nome
 * 1 = stato
 * 2 = orientation
 * 3 = x
 * 4 = y
 * 5 = "" (colpo x)
 * 6 = "" (colpo y)
 * 
 * </p>*/
		public void bornPlayer(String[] info) throws RemoteException {
			info[5]="";
			info[6]="";
			Server.instance.addPlayer(info);
		}


		public void killPlayer(String nomePlayer) throws RemoteException {
			Server.instance.removePlayer(nomePlayer);			
		}


		@Override
		public String leggiOstacoli() throws RemoteException {
		        String ostacoli = "";
		        try{
		            new File((getClass().getResource("/gdr/maps/bk.jpg").getFile()).replaceAll("jpg", "txt")).createNewFile();
		            String fileName  = (getClass().getResource("/gdr/maps/bk.jpg").getFile()).replaceAll("jpg", "txt");
		            FileReader inputFileReader   = new FileReader(fileName);
		            BufferedReader inputStream   = new BufferedReader(inputFileReader);
		            ostacoli = inputStream.readLine();
		            inputStream.close();
		            }
		        catch(Exception ex){ex.printStackTrace();}
		        return ostacoli;
		}


		@Override
		public void assegnaColpo(String nomePlayer, Point p) throws RemoteException {
			for (String[] nf:Server.instance.playerList){
        		if (nf[0].equals(nomePlayer))
        			{
        			 nf[5] = ""+p.x;
        			 nf[6] = ""+p.y;
        			}
        	}
		}
		
		@Override
		public void colpoRicevuto(String nomePlayer) throws RemoteException {
			for (String[] nf:Server.instance.playerList){
        		if (nf[0].equals(nomePlayer))
        			{
        			 nf[5] = "";
        			 nf[6] = "";
        			}
        	}
		}
}